/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: PNSIF_Functionlist.h 37738 2013-08-26 13:51:24Z andreasme $
   Last Modification:
    $LastChangedBy: andreasme $
    $LastChangedDate: 2013-08-26 15:51:24 +0200 (Mo, 26 Aug 2013) $
    $LastChangedRevision: 37738 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNS IF
    Task function list for configuration file

   Changes:

    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2010-06-28  D. Janssen   rename of PNS_IF_DISABLE_STACK_STORE_REMANENT - the configuration
                                shall now be done by SetConfigurationRequest

    2010-05-03  B. Meyer     removed definitions from 2010-04-2010 for mantis #9447 as
                                they are not needed

    2010-04-28  B. Meyer     introduced PNS_IF_STARTUP_PARAM_VERSION_7 and added
                                flash parameters to startup parameters

    2010-04-20  B. Meyer     added new startup flag PNS_IF_SET_IP_0_0_0_0_WITHOUT_CFG
                                to fixed mantis #9477

    2010-04-07  B. Meyer     added instances of the LEDs to the startup parameters
                                to fix mantis #8857

    2009-12-09  A. Messer    introduced new startup parameter for use with synchronization
    												 interrupt
    
    2009-11-20  B. Meyer     added flag PNS_IF_FIBER_OPTIC_HARDWARE to set fiber optic mode
                             introduced new startup parameter ulEthPortCnt and changed startup
                                parameter to V3

    2009-09-24  B. Meyer     added flag PNS_IF_DISABLE_HIF to disable the usage of all
	                            HIF-related functions and actions

    2009-05-20  B. Meyer     fixed wrong value of PNS_IF_DISABLE_STACK_STORE_REMANENT
                             changed types of psz... elements to TLR_STR*

    2009-01-13  B. Meyer     added flag PNS_IF_DISABLE_STACK_STORE_REMANENT
                             renamed pstName to pszEddName in Startup Parameters
                             added some fields to Startup Parameters
                                pszSFLedName, pszBFLedName, pszSignalLedName

    2008-12-01  A. Messer    Added Flag field to Startup parameters.

    2008-11-28  B. Meyer     added pszName to Startup Parameters


**************************************************************************************/
/**
 * @file PNSIF_Functionlist.h
 * @brief PNS IF - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNSIF</code>
 * of task.
 */
#ifndef __PNS_IF_FUNCTIONLIST_H
#define __PNS_IF_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNSIF
(
  TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_PNSIF
(
  TLR_VOID FAR* pvRsc,
  TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_PNSIF
(
  TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNS_IF_STARTUP_PARAM_VERSION_1 (1)
#define PNS_IF_STARTUP_PARAM_VERSION_2 (2)
#define PNS_IF_STARTUP_PARAM_VERSION_3 (3)
#define PNS_IF_STARTUP_PARAM_VERSION_4 (4)
#define PNS_IF_STARTUP_PARAM_VERSION_5 (5)
#define PNS_IF_STARTUP_PARAM_VERSION_6 (6)
#define PNS_IF_STARTUP_PARAM_VERSION_7 (7)
#define PNS_IF_STARTUP_PARAM_VERSION_8 (8)
#define PNS_IF_STARTUP_PARAM_VERSION_9 (9)

typedef enum
{
  PNS_IF_DISABLE_DBM                  = 0x00000001, /* if set sycon.net database is not evaluated */
  PNS_IF_DISABLE_LEDS                 = 0x00000002, /* if set LEDs will not be handled by the stack */
  PNS_IF_DISABLE_HIF                  = 0x00000008, /* if set the HIF is not used - the user has to use callback */
                                                    /* functions to access IO-Data */
  PNS_IF_FIBER_OPTIC_HARDWARE         = 0x00000010, /* if set the stack will be configured for usage of fiber optic */
                                                    /* this influences LLDP and the PDEV functionality */
  PNS_IF_USE_PN_IDENT_PARAM           = 0x00000020, /* if set the task will use the parameters usVendorId and usDeviceId */
} PNS_IF_STARTUP_PARAM_FLAGS_E;

typedef struct
{
  RX_PHYSICALDRIVE_HEADER_T  tIdentParam;
  TLR_UINT32                 ulBytePerFlashSector;
  TLR_UINT32                 ulFATStartOffset;
} PNS_IF_FLASH_PARAM_T;

/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNS_IF_STARTUPPARAMETER_Ttag  PNS_IF_STARTUPPARAMETER_T_V5;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNS_IF_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** DPM channel */
  TLR_UINT32  ulDPMChannel;
  /** name of EDD to identify*/
  TLR_STR*    pszEddName;
  /** flags to define behavior of pns if for certain cases */
  TLR_UINT32  ulPNSIFFlags;
  /** name of SF LED to identify */
  TLR_STR*    pszSFLedName;
  /** name of BF LED to identify */
  TLR_STR*    pszBFLedName;
  /** name of LED to use for special signal event */
  TLR_STR*    pszSignalLedName;
  /** amount of Ethernet ports available */
  TLR_UINT32  ulEthPortCnt;

  /** name of synchronize isr can be either fiq or standard int, set to NULL if not used */
  STRING*     pszSynchronizeIrqName;
  /** instance of synchronize irq, set to 0 if not used */
  UINT32      uSynchronizeIrqInstance;

  /* new for V5 */
  /** name and instances of the phy */
  struct
  {
    STRING* pszPhyName;
    UINT32  uPhyInstance;
  } atPhy[2];

  /* new for V6 */
  /* instance of the SF LED */
  TLR_UINT32  ulSFLedInstance;
  /* instance of the BF LED */
  TLR_UINT32  ulBFLedInstance;
  /* instance of the Signal LED */
  TLR_UINT32  ulSignalLedInstance;

  /* new for V7 */
  /** pointer to flash parameters - if set to != NULL the NameOfStation and IP-Parameters
   *  are stored in a raw sector inside the flash without writing into filesystem.
   *  Note: Some other, rarely changed parameters are still written to file system.*/
  PNS_IF_FLASH_PARAM_T* ptFlashPrm;

  /* new for V8 */
  /* Profinet VendorID to use in case of database evaluation (value contained in TagList) */
  TLR_UINT16    usVendorId;
  /* Profinet DeviceID to use in case of database evaluation (value contained in TagList) */
  TLR_UINT16    usDeviceId;

  /* new for V9 */
  /* mau type of fiber optic device */
  TLR_UINT16    usFOMauType;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNS_IF_FUNCTIONLIST_H */
